/* Copyright (c) 2004, 2007, Oracle. All rights reserved.  */

/*

   NAME
     insert2.c - <one-line expansion of the name>

   DESCRIPTION
     <short description of facility this file declares/defines>

   EXPORT FUNCTION(S)
     <external functions defined for use outside package - one-line description>

   INTERNAL FUNCTION(S)
     <other external functions defined - one-line descriptions>

   STATIC FUNCTION(S)
     <static functions defined - one-line descriptions>

   NOTES
     <other useful comments, qualifications, etc.>

   MODIFIED   (MM/DD/YY)
   sprabhak    01/31/08 - Fix bug 6781690 
   sprabhak    08/06/07 - Fix bug 6319119
   mvasudev    03/29/07 - ifdef change
   sprabhak    02/16/05 - Fix for bug 4994424
   sprabhak    06/20/05 - Error handling
   ardesai     03/04/05 - Include windows.h for windows platform.
   subanerj    06/06/04 - subanerj_odbc_env_setup
   ardesai     06/02/04 - Creation

*/

#ifdef WIN32COMMON
#include <windows.h>
#endif

#include <stdio.h>
#include <sql.h>
#include <sqlext.h>

#define  STR_LEN 50

int main ()
{
  HENV           henv;              /* environment handle */
  HDBC           hdbc;              /* connection handle  */
  HSTMT          hstmt;             /* statement handle   */
  SDWORD         retcode;           /* return code        */
  SQLCHAR* stmt = "insert into emp(empno, ename, sal) values (?,?,?)";
  SQLCHAR        ename[STR_LEN];
  SQLULEN empno, sal;
  #ifdef _WIN64  
    SQLLEN enameInd=SQL_NTS,salInd=0,enoInd=0;
  #elif  BUILD_REAL_64_BIT_MODE
    SQLLEN enameInd=SQL_NTS,salInd=0,enoInd=0;
  #else
    SQLINTEGER     enameInd = SQL_NTS, salInd = 0, enoInd = 0;
  #endif
  SQLCHAR        SqlState[6], Msg[SQL_MAX_MESSAGE_LENGTH];
  SQLINTEGER     NativeError;
  SQLSMALLINT    MsgLen;

  retcode = SQLAllocEnv (&henv);
  retcode = SQLSetEnvAttr (henv, SQL_ATTR_ODBC_VERSION, (void *) SQL_OV_ODBC3,
              SQL_IS_INTEGER);
  retcode = SQLAllocConnect (henv, &hdbc);

  retcode = SQLConnect (hdbc, "TestDBDSN", SQL_NTS, "scott", SQL_NTS, "tiger",
              SQL_NTS);
  if (retcode != SQL_SUCCESS)
    {
      retcode = SQLGetDiagRec (SQL_HANDLE_DBC, hdbc, 1,
                  SqlState, &NativeError, Msg, sizeof (Msg), &MsgLen);
      printf ("SqlState = %s\n Message = %s\n", SqlState, Msg);
      goto EXIT;
    }

  retcode = SQLAllocHandle (SQL_HANDLE_STMT, hdbc, &hstmt);

  retcode = SQLPrepare (hstmt, stmt, SQL_NTS);
  if (retcode != SQL_SUCCESS)
    {
      retcode = SQLGetDiagRec (SQL_HANDLE_STMT, hstmt, 1,
                  SqlState, &NativeError, Msg, sizeof (Msg), &MsgLen);
      printf ("SqlState = %s\n Message = %s\n", SqlState, Msg);
      goto EXIT;
    }

  if ((retcode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_ULONG,
                   SQL_INTEGER, 4, 0, &empno, sizeof (empno),
                   &enoInd)) != SQL_SUCCESS)
    goto EXIT;
  if ((retcode = SQLBindParameter (hstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR,
                   SQL_VARCHAR, 0, 0, &ename[0], 40,
                   &enameInd)) != SQL_SUCCESS)
    goto EXIT;
  if ((retcode = SQLBindParameter (hstmt, 3, SQL_PARAM_INPUT, SQL_C_ULONG,
                   SQL_INTEGER, 4, 0, &sal, sizeof (sal),
                   &salInd)) != SQL_SUCCESS)
    goto EXIT;

  empno = 111;
  ename[0] = 'K';
  ename[1] = 'R';
  ename[2] = '\0';
  sal = 9898;
  retcode = SQLExecute (hstmt);
  if (retcode != SQL_SUCCESS)
    {
      retcode = SQLGetDiagRec (SQL_HANDLE_STMT, hstmt, 1,
                  SqlState, &NativeError, Msg, sizeof (Msg), &MsgLen);
      printf ("SqlState = %s\n Message = %s\n", SqlState, Msg);
      goto EXIT;
    }

  SQLEndTran (SQL_HANDLE_ENV, henv, SQL_COMMIT);
  printf ("Insert is successful\n");

EXIT:
  SQLFreeStmt (hstmt, SQL_CLOSE);
  SQLDisconnect (hdbc);
  SQLFreeConnect (hdbc);
  SQLFreeEnv (henv);
  return 0;
}

/* end of file insert2.c */
